% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_linked_courses.R
\name{read_linked_courses}
\alias{read_linked_courses}
\title{Read linked courses files}
\usage{
read_linked_courses(path = "", format = "xlsx", encoding = "latin1")
}
\arguments{
\item{path}{The linked courses file's path.}

\item{format}{You can choose between xlsx or csv.}

\item{encoding}{This function uses latin1 by default but you can use UTF-8 if needed.}
}
\value{
A data frame.
}
\description{
This function reads a .xlsx/.csv file with the linked courses between Sistec and the academic
registration.  The columns must be in this order: INICIO, CICLO, CURSO_SISTEC,
CURSO_RFEPT and CAMPUS. The date in INICIO column must be in yyyy.period.
Ex.: 2019.1 or 2019.2. .
}
\examples{
 
linked_courses <- read_linked_courses(system.file("extdata/examples/linked_courses",
                                                  package = "sistec"), "csv")

linked_courses
}
