% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilityClass.R
\name{turnerStabilityClass}
\alias{turnerStabilityClass}
\title{Turner stability class}
\usage{
turnerStabilityClass(
  datetime,
  longitude,
  latitude,
  ws,
  cloud_cover,
  ceiling_height
)
}
\arguments{
\item{datetime}{datetime object (class POSIXct). Either a single value or
a vector}

\item{longitude, latitude}{geographical coordinates (in degrees) of the point
of interest}

\item{ws}{wind speed at 10 m (in m/s)}

\item{cloud_cover}{Total cloud cover in the range 1...8}

\item{ceiling_height}{Ceiling height in metres}
}
\value{
A numeric value (or vector) in the range 1 to 6, where 1 = A, 2 = B, ...,
6 = F.
}
\description{
Computes PGT stability class using Turner method, based on the local
wind speed, cloud cover, ceiling
height and solar elevation.
}
\details{
If \code{datetime} is a vector, an equal length vector for the other input
parameters is expected. It is also possible to provide a single value
for the other parameters; in that case the value is kept constant along
all the deadlines.
}
\examples{

# Single value example:
turnerStabilityClass(
    datetime = as.POSIXct("2024-12-01 13:00", tz = "ETC/GMT-1"),
    longitude = 7.12,
    latitude = 45.10,
    ws = 3,
    cloud_cover = 3,
    ceiling_height = 3000
)

# datetime vector with constant values
deadlines <- seq(
    from = as.POSIXct("2024-12-01 00:00"),
    to = as.POSIXct("2024-12-31 23:00"),
    length.out = 24 * 31
)
turnerStabilityClass(
    datetime = deadlines,
    longitude = 7.12,
    latitude = 45.10,
    ws = 3,
    cloud_cover = 3,
    ceiling_height = 3000
)


}
\seealso{
\code{\link[=stabilityClass]{stabilityClass()}} which computes stability class with other methods.
\code{\link[=plotStabilityClass]{plotStabilityClass()}} to produce graphical outputs with stability class.
}
