% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_plotSbm.R
\name{plotSbm.SimpleSBM_fit}
\alias{plotSbm.SimpleSBM_fit}
\title{plotSbm.SimpleSBM_fit Method}
\usage{
\method{plotSbm}{SimpleSBM_fit}(
  x,
  ordered = FALSE,
  transpose = FALSE,
  labels = NULL,
  plotOptions = list()
)
}
\arguments{
\item{x}{Sbm model of class `"SimpleSBM_fit"`}

\item{ordered}{Boolean. Set \code{TRUE} if the matrix should be reordered (Default is \code{FALSE})}

\item{transpose}{isn't used in this method}

\item{labels}{named list (names should be: `"col"` and `"row"`) of characters describing columns and rows component (Default is \code{NULL})}

\item{plotOptions}{list providing options. See details below.}
}
\value{
a ggplot object corresponding to the matrix plot inside the app.
Groups the network matrix is organized by blocks, the small tiles are for
individuals connections. The big tiles between red lines are for block connectivity
}
\description{
plotSbm method for SimpleSBM_fit object
}
\details{
The list of parameters \code{plotOptions} for the matrix plot is
\describe{
 \item{"showValues": }{Boolean. Set TRUE to see the real values. Default value is TRUE}
 \item{"showPredictions": }{Boolean. Set TRUE to see the predicted values. Default value is TRUE}
 \item{"title": }{Title in characters. Will be printed at the bottom of the matrix. Default value is NULL}
 \item{"colPred": }{Color of the predicted values, the small values will be more transparent. Default value is "red"}
 \item{"colValue": }{Color of the real values, the small values will close to white. Default value is "black"}
 \item{"showLegend": }{Should a legend be printed ? TRUE or FALSE, default:  FALSE}
 \item{"interactionName": }{Name of connection in legend default: "Connection"}
}
}
\examples{

# my_sbm_uni <- sbm::estimateSimpleSBM(sbm::fungusTreeNetwork$tree_tree,
#                                      model = "poisson")
my_sbm_uni <- FungusTreeNetwork$sbmResults$tree_tree

plotSbm(my_sbm_uni,
  ordered = TRUE,
  plotOptions = list(title = "An example Matrix")
)

}
