% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setmapmi.R
\name{setmapmi}
\alias{setmapmi}
\title{setmapmi}
\usage{
setmapmi(original_variables = NULL, sets = NULL, n_elements = NULL)
}
\arguments{
\item{original_variables}{Character vector of names for the original
variables that were paired (typically `pairmi_result$original.variables`).}

\item{sets}{A data frame returned by [pairmi()] describing the sets. Must
contain the columns required by `setmapmi()` (e.g., identifiers for sets
and their constituent variables).}

\item{n_elements}{Integer scalar giving the set size (depth) to visualize
(e.g., `2` for pairs, `3` for triplets). Must be >= 1 and present in
`sets`.}
}
\value{
A setmap showing which original variables make up the sets at a
  certain depth
}
\description{
Creates a set map visualization from the output of [pairmi()],
showing which original variables compose the derived sets at a specified
depth.
}
\examples{
pairmiresult = pairmi(misimdata[,2:6])
setmapmi(pairmiresult$original.variables,pairmiresult$sets,2)
}
