% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{sessioncheck}
\alias{sessioncheck}
\title{Checks the overall status of the R session}
\usage{
sessioncheck(action = NULL, checks = NULL, ...)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". If the user does not specify an action
the default to set \code{action = "warn"}.}

\item{checks}{Character vector listing the checks to run. If the user does not
specify the checks, the default is to run
\code{checks = c("globalenv_objects", "attached_packages", "attached_environments")}.}

\item{...}{Arguments passed to individual checks.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_sessioncheck}.
}
\description{
Individual session check functions that each inspect one way in which an R
session could be considered not to be "clean". Session checkers can produce
errors, warnings, or messages if requested.
}
\details{
\code{sessioncheck()} allows the user to apply multiple session checks in a single function.
The following arguments are recognised via \code{...}:
\itemize{
\item \code{allow_globalenv_objects} is passed to \code{check_globalenv_objects()}
\item \code{allow_attached_packages} is passed to \code{check_attached_packages()}
\item \code{allow_attached_environments} is passed to \code{check_attached_environments()}
\item \code{allow_loaded_namespaces} is passed to \code{check_loaded_namespaces()}
\item \code{max_sessiontime} is passed to \code{check_sessiontime()}
\item \code{required_options} is passed to \code{check_required_options()}
\item \code{required_locale} is passed to \code{check_required_locale()}
\item \code{required_sysenv} is passed to \code{check_required_sysenv()}
}

Other arguments are ignored.
}
\examples{
sessioncheck(action = "message")
 
}
