% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_required_options}
\alias{check_required_options}
\title{Check required values for options}
\usage{
check_required_options(action = "warn", required_options = NULL)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{required_options}{A named list of required options. If any of these options are
missing or have different values to the required values, an action is triggered.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check function that inspects the options.
Session checkers can produce errors, warnings, or messages if requested.
}
\examples{
check_required_options(action = "message", required_options = list(scipen = 0L, max.print = 50L))

}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
