% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_scores.R
\name{return_scores}
\alias{return_scores}
\title{Returns the score (calculated) items from \code{secuTrialdata} objects}
\usage{
return_scores(x)
}
\arguments{
\item{x}{a \code{secuTrialdata} object}
}
\value{
a data.frame (columns: name, itemtype, label) that pinpoints which items are scores/calculated.
}
\description{
secuTrial allows to set up calculated fields (i.e. scores) that depend on other items. It is not
             suggested to use the scores calculated by secuTrial to perform reliable analyses. To this end,
             calling \code{return_scores} will return all items in the secuTrial export which are scores and should
             be manually recalculated before data analysis.
}
\examples{
# export location
expot_loc <- system.file("extdata", "sT_exports", "lnames",
                         "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                         package = "secuTrialR")
# read export
sT_export <- read_secuTrial(expot_loc)

# return scores
return_scores(sT_export)

}
