% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func.R
\name{step}
\alias{step}
\title{Create step function}
\usage{
step(times, start, height = 1)
}
\arguments{
\item{times}{Vector of simulation times}

\item{start}{Start time of step}

\item{height}{Height of step, defaults to 1}
}
\value{
Step interpolation function
}
\description{
Create a step function that jumps from zero to a specified height at a specified time, and remains at that height until the end of the simulation time.
}
\details{
Equivalent of Step() in Insight Maker
}
\examples{
# Create a simple model with a step function
# that jumps at time 50 to a height of 5
sfm <- xmile() |>
  build("a", "stock") |>
  # Specify the global variable "times" as simulation times
  build("input", "constant", eqn = "step(times, 50, 5)") |>
  build("inflow", "flow", eqn = "input(t)", to = "a")

\dontshow{
sfm <- sim_specs(sfm, dt = .1)
}

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)

# Negative heights are also possible
sfm <- build(sfm, "input", eqn = "step(times, 50, -10)")

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)
}
\seealso{
\code{\link[=ramp]{ramp()}}, \code{\link[=pulse]{pulse()}}, \code{\link[=seasonal]{seasonal()}}
}
\concept{input}
