test_that("sd_neighbors",
{
  correct_sd_neighbors_l_r <- c(0.0, 0.5, 0.0)
  correct_sd_neighbors_r_r <- c(0.0, 0.5, 0.0)
  correct_sd_neighbors_b_r <- c(0.0, 0.5, 0.0)
  correct_sd_neighbors_a_r <- c(0.40000000000000019, 0.74833147735478744, 0.79999999999999993)
  expect_equal(sd_neighbors(b, w, "l")[idx_lp], correct_sd_neighbors_l_r)
  expect_equal(sd_neighbors(b, w, "r")[idx_lp], correct_sd_neighbors_r_r)
  expect_equal(sd_neighbors(b, w, "b")[idx_lp], correct_sd_neighbors_b_r)
  expect_equal(sd_neighbors(b, w, "a")[idx_lp], correct_sd_neighbors_a_r)
  
  correct_sd_neighbors_l_p <- c(1.0, 0.5, 0.0)
  correct_sd_neighbors_r_p <- c(0.0, 0.5, 0.5)
  correct_sd_neighbors_b_p <- c(0.8660254037844386, 0.5000000000000000, 0.4330127018922193)
  correct_sd_neighbors_a_p <- c(0.80000000000000004, 0.74833147735478744, 0.80000000000000004)
  expect_equal(sd_neighbors(b, w, "l", "p")[idx_lp], correct_sd_neighbors_l_p)
  expect_equal(sd_neighbors(b, w, "r", "p")[idx_lp], correct_sd_neighbors_r_p)
  expect_equal(sd_neighbors(b, w, "b", "p")[idx_lp], correct_sd_neighbors_b_p)
  expect_equal(sd_neighbors(b, w, "a", "p")[idx_lp], correct_sd_neighbors_a_p)
  
  correct_sd_neighbors_l_d <- c(NA, 0.5, NA)
  correct_sd_neighbors_r_d <- c(NA, 0.5, NA)
  correct_sd_neighbors_b_d <- c(NA, 0.5, NA)
  correct_sd_neighbors_a_d <- c(NA, 0.74833147735478744, NA)
  expect_equal_na_allowed(sd_neighbors(b, w, "l", "d")[idx_lp], correct_sd_neighbors_l_d)
  expect_equal_na_allowed(sd_neighbors(b, w, "r", "d")[idx_lp], correct_sd_neighbors_r_d)
  expect_equal_na_allowed(sd_neighbors(b, w, "b", "d")[idx_lp], correct_sd_neighbors_b_d)
  expect_equal_na_allowed(sd_neighbors(b, w, "a", "d")[idx_lp], correct_sd_neighbors_a_d)
})
