% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{schwab_auth2_refreshToken}
\alias{schwab_auth2_refreshToken}
\title{Auth Step 2: Obtain Refresh Token}
\usage{
schwab_auth2_refreshToken(appKey, appSecret, callbackURL, codeToken)
}
\arguments{
\item{appKey}{'Schwab API' generated App Key for the registered app.}

\item{appSecret}{'Schwab API' generated Secret for the registered app.}

\item{callbackURL}{Users Callback URL for the registered app}

\item{codeToken}{Will be the URL at the end of Auth Step 1. Somewhere in the
URL you should see code=CO.xxx. Paste the entire URL into the function.}
}
\value{
Refresh Token that is valid for 7 days
}
\description{
Get a Refresh Token using the Authorization Code
}
\details{
Once a URL has been generated using \code{\link{schwab_auth1_loginURL}}, a user
can visit that URL to grant access to Schwab accounts. Once the button "Done"
at the end of the process is pressed, the user will be
redirected, potentially to "This site can't be reached". This indicates a
successful log in. The URL of this page contains the Authorization Code.
Paste the entire URL, not just the Authorization Code, into
schwab_auth2_refreshToken. The authorization code will be a long alpha
numeric string starting with 'https' and having 'code=' embedded.

The output of schwab_auth2_refreshToken will be a Refresh Token which will be used
to gain access to the Schwab account(s) going forward. The Refresh
Token will be valid for 7 days. Be sure to save the Refresh Token to a safe
location.

The Refresh Token is needed to generate an Access Token using
\code{\link{schwab_auth3_accessToken}}, which is used for general account access.
The Access Token expires after 30 minutes but the Refresh Token remains
active for 7 days. You want to store your refresh token somewhere safe
so that you can reference it later to regenerate an authorization token. After 7
days you have to manually log in again. The 'Schwab API' team indicated this might
change in the future, but no set timeline.
}
\examples{
\dontrun{

# Initial access will require manually logging in to the URL from schwab_auth1_loginURL
# After a successful log in, the URL authorization code can be fed with a callbackURL
tok = schwab_auth2_refreshToken(appKey = 'schwab_APP_KEY',
                               appSecret = 'schwab_SECRET',
                               callbackURL = 'https://127.0.0.1',
                               codeToken = 'https://127.0.0.1?code=Auhtorizationcode')


# Save the Refresh Token somewhere safe where it can be retrieved
saveRDS(tok$refresh_token,'/secure/location/')

}
}
\seealso{
\code{\link{schwab_auth1_loginURL}} to generate a login url which leads
  to an authorization code, and more importantly generated a Refresh Token, you can feed
  the refresh token into \code{\link{schwab_auth3_accessToken}}
  to generate a new Access Token
}
