% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_freq.R
\name{scf_freq}
\alias{scf_freq}
\title{Estimate the Frequencies of a Discrete Variable from SCF Microdata}
\usage{
scf_freq(scf, var, by = NULL, percent = TRUE)
}
\arguments{
\item{scf}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}. Must contain five replicate-weighted implicates.}

\item{var}{A one-sided formula specifying a categorical variable (e.g., \code{~racecl}).}

\item{by}{Optional one-sided formula specifying a discrete grouping variable (e.g., \code{~own}).}

\item{percent}{Logical. If \code{TRUE} (default), scales results and standard errors to percentages.}
}
\value{
A list of class \code{"scf_freq"} with:
\describe{
\item{results}{Pooled category proportions and standard errors, by group if specified.}
\item{imps}{A named list of implicate-level proportion estimates.}
\item{aux}{Metadata about the variable and grouping structure.}
}
}
\description{
This function estimates the relative frequency (proportion) of each category
in a discrete variable from the SCF public-use microdata.  Use this function
to discern the univariate distribution of a discrete variable.
}
\details{
Computes weighted proportions and standard errors for a discrete variable
in multiply-imputed SCF data, optionally stratified by a grouping variable.
Proportions and standard errors are computed separately within each
implicate using \code{svymean()}, then averaged across
implicates using SCF-recommended pooling logic. Group-wise frequencies are
supported, but users may find the features of \code{\link[=scf_xtab]{scf_xtab()}} to be more useful.
}
\section{Details}{

Proportions are estimated within each implicate using \code{survey::svymean()},
then pooled using the standard MI formula for proportions. When a grouping
variable is provided via \code{by}, estimates are produced separately for each
group-category combination. Results may be scaled to percentages using the
\code{percent} argument.

Estimates are pooled using the standard formula:
\itemize{
\item The mean of implicate-level proportions is the point estimate
\item The standard error reflects both within-implicate variance and across-implicate variation
}

Unlike means or model parameters, category proportions do not use Rubin's full combination rules (e.g., degrees of freedom).
}

\examples{
# Ignore this code block.  It loads mock data for CRAN.
# In your analysis, download and load your data using the
# functions `scf_download()` and `scf_load()`
td <- tempfile("freq_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# EXAMPLE IMPLEMENTATION: Proportions of homeownership
scf_freq(scf2022, ~own)

# EXAMPLE IMPLEMENTATION: Cross-tabulate education by homeownership
scf_freq(scf2022, ~own, by = ~edcl)

# Ignore the code below.  It is for CRAN:
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_xtab]{scf_xtab()}}, \code{\link[=scf_plot_dist]{scf_plot_dist()}}]
}
