% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from-r.R
\name{sas_from_r}
\alias{sas_from_r}
\title{Convert R table to SAS}
\usage{
sas_from_r(x, table_name, libref = "WORK", factors_as_strings = TRUE)
}
\arguments{
\item{x}{\code{data.frame}; R table.}

\item{table_name}{string; Name of table to be created in SAS.}

\item{libref}{string; Name of libref to store SAS table within.}

\item{factors_as_strings}{logical; If \code{TRUE}, factors will become SAS strings.
Else, factors will become formatted numerics.}
}
\value{
\code{data.frame}; \code{x}.
}
\description{
Converts R table into a table in the current SAS session. R tables must only
have logical, integer, double, factor, character, POSIXct, or Date class
columns.
}
\details{
SAS only has two data types (numeric and character). Data types are converted
as follows:
\itemize{
\item logical -> numeric
\item integer -> numeric
\item double -> numeric
\item factor -> character
\item character -> character
\item POSIXct -> numeric (datetime; timezones are lost)
\item Date -> numeric (date)
}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect()

sas_from_r(mtcars, "mtcars")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sas_to_r]{sas_to_r()}}
}
