% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-download.R
\name{sas_file_download}
\alias{sas_file_download}
\title{Download a file from SAS}
\usage{
sas_file_download(sas_path, local_path)
}
\arguments{
\item{sas_path}{string; Path of file on remote SAS server to be download}

\item{local_path}{string; Path to upload SAS file to on local machine.}
}
\value{
\code{logical}; value indicating if the operation succeeded.
}
\description{
Downloads a file to the remote SAS server.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# connect to SAS
sas_connect()

# create an example file
local_path <- tempfile(fileext = ".txt")
cat("some example text", file = tempfile_path)

sas_path <- readline(
  "Please provide the full path to upload an example file to (e.g., ~/example.txt)."
)
sas_file_upload(local_path, sas_path)

# download the uploaded file
local_copy_path <- sub("\\\\.txt$", "_copy.txt", tempfile_path)
sas_file_download(sas_path, local_copy_path)

# cleanup
unlink(local_path)
unlink(local_copy_path)
sas_file_remove(sas_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other file management functions: 
\code{\link{sas_file_copy}()},
\code{\link{sas_file_exists}()},
\code{\link{sas_file_remove}()},
\code{\link{sas_file_upload}()},
\code{\link{sas_list}()}
}
\concept{file management functions}
