% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_mesos_structure.R
\name{setup_mesos_structure}
\alias{setup_mesos_structure}
\title{Create directory structure for mesos reports (improved version)}
\usage{
setup_mesos_structure(
  main_directory,
  files_to_process,
  mesos_groups,
  mesos_var_subfolder = character(),
  files_taking_title = c("index.qmd", "report.qmd"),
  subtitle_separator = " - ",
  include_prefix = "{{< include \\"",
  include_suffix = "\\" >}}"
)
}
\arguments{
\item{main_directory}{String. Path to where the structure will be created. Can be
an absolute path or relative path. The path will be created if it doesn't exist.
Unlike \code{\link[=setup_mesos]{setup_mesos()}}, this parameter is required and has no default to avoid
accidental file creation in unexpected locations.}

\item{files_to_process}{Character vector of paths to template QMD files to use
as the basis for creating stub files. These files should typically have
filenames starting with underscore (e.g., \verb{_report.qmd}).}

\item{mesos_groups}{A named list or data frame specifying the grouping structure.
\itemize{
\item If a \strong{named list}: names are mesos variable names, values are character
vectors of group names. Example: \code{list(region = c("North", "South", "East"))}
\item If a \strong{data frame}: Use the same format as \code{\link[=setup_mesos]{setup_mesos()}} - a list of
single-column data frames with optional variable labels.
}}

\item{mesos_var_subfolder}{Optional character vector. Subfolder path(s) within
each mesos variable folder where group folders should be placed. Default is
no subfolder (empty character vector).}

\item{files_taking_title}{Character vector of filenames that should receive
title metadata. Default is \code{c("index.qmd", "report.qmd")}.}

\item{subtitle_separator}{String or NULL. If a string, adds title and subtitle
fields to \verb{_metadata.yml} files in the deepest child folders. The subtitle
is a concatenation of the output directory basename, mesos variable label,
and group name. Default is \code{" - "}. Set to \code{NULL} to disable.}

\item{include_prefix, include_suffix}{Strings for the include directive in stub
QMD files. Default creates Quarto-style includes: \verb{\{\{< include "..." >\}\}}}
}
\value{
Invisibly returns a list with information about created files.
}
\description{
This is an improved, easier-to-use version of \code{\link[=setup_mesos]{setup_mesos()}}. It creates the
directory structure, QMD stub files, and YAML metadata files needed for mesos
(multi-group) reports without requiring manual working directory management.
}
\examples{
\dontrun{
# Simple example with a named list
setup_mesos_structure(
  main_directory = "reports/2024",
  files_to_process = c("_report.qmd", "_index.qmd"),
  mesos_groups = list(
    region = c("North", "South", "East", "West"),
    department = c("Sales", "Marketing", "IT")
  )
)

# With subfolder and custom labels
setup_mesos_structure(
  main_directory = "./output",
  files_to_process = "_analysis.qmd",
  mesos_groups = list(
    country = c("Norway", "Sweden", "Denmark")
  ),
  mesos_var_subfolder = "reports/Q1"
)
}
}
