% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visitation.R
\name{visitation_net}
\alias{visitation_net}
\alias{visitation_net,samc,missing,location,missing-method}
\alias{visitation_net,samc,missing,location,location-method}
\alias{visitation_net,samc,ANY,missing,missing-method}
\alias{visitation_net,samc,ANY,missing,location-method}
\title{Calculate net visitation}
\usage{
visitation_net(samc, init, origin, dest)

\S4method{visitation_net}{samc,missing,location,missing}(samc, origin)

\S4method{visitation_net}{samc,missing,location,location}(samc, origin, dest)

\S4method{visitation_net}{samc,ANY,missing,missing}(samc, init)

\S4method{visitation_net}{samc,ANY,missing,location}(samc, init, dest)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object created using the \code{\link{samc}} function.}

\item{init}{Sets the initial state \eqn{\psi} of the transients states. Input
must be able to pass the \code{\link{check}} function when compared against
the \code{\link{samc-class}} object. Can only contain positive finite values.}

\item{origin}{A positive integer or character name representing transient state
\eqn{\mathit{i}}. Corresponds to row \eqn{\mathit{i}} of matrix \eqn{\mathbf{P}}
in the \code{\link{samc-class}} object. When paired with the \code{dest}
parameter, multiple values may be provided as a vector.}

\item{dest}{A positive integer or character name representing transient state
\eqn{\mathit{j}}. Corresponds to column \eqn{\mathit{j}} of matrix \eqn{\mathbf{P}}
in the \code{\link{samc-class}} object. When paired with the \code{origin} parameter,
multiple values may be provided as a vector.}
}
\value{
See Details
}
\description{
Calculates the net number of times that transient states are visited before absorption.
}
\details{
Add details here
}
\section{Performance}{


Performance details are in the performance vignette:
\code{vignette("performance", package = "samc")}.
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::example_split_corridor$res
abs_data <- samc::example_split_corridor$abs
init_data <- samc::example_split_corridor$init


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, init_data)

# Setup the details for a random-walk model
rw_model <- list(fun = function(x) 1/mean(x), # Function for calculating transition probabilities
                 dir = 8, # Directions of the transitions. Either 4 or 8.
                 sym = TRUE) # Is the function symmetric?


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers.
samc_obj <- samc(res_data, abs_data, model = rw_model)


# Convert the initial state data to probabilities
init_prob_data <- init_data / sum(init_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, init_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, init_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
