% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatchery.R
\name{calc_smolt}
\alias{calc_smolt}
\title{Smolt production}
\usage{
calc_smolt(
  N1,
  N2 = N1,
  kappa,
  capacity,
  Smax,
  phi = 1,
  fitness_loss = 1,
  SRrel = c("BH", "Ricker"),
  per_recruit = FALSE
)
}
\arguments{
\item{N1}{Egg production for the density-independent component of the stock-recruit relationship. Can be the number of spawners if \code{phi = 1}
and \code{Smax} is in units of spawners.}

\item{N2}{Egg production for the density-dependent component of the stock-recruit relationship (only used if \code{per_recruit = FALSE})}

\item{kappa}{Base productivity parameter}

\item{capacity}{Base capacity parameter if \code{SRrel = "BH"}}

\item{Smax}{Base Smax parameter if \code{SRrel = "Ricker"}}

\item{phi}{Unfished egg per smolt (\code{1/phi} is the replacement line)}

\item{fitness_loss}{Survival term to reduce smolt production due to fitness, between 0-1}

\item{SRrel}{Character for the stock-recruit function}

\item{per_recruit}{Logical, whether N1 is a per recruit quantity (TRUE) or in absolute numbers (FALSE)}
}
\value{
Numeric
}
\description{
Calculate smolt production from base stock-recruit parameters and fitness loss
}
