% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuroAtlanticTC.R
\name{EuroAtlanticTC}
\alias{EuroAtlanticTC}
\title{Teleconnection indices in European Atlantic Ocean region}
\usage{
EuroAtlanticTC(
  ano,
  lat,
  lon,
  ntrunc = 30,
  time_dim = "sdate",
  space_dim = c("lat", "lon"),
  corr = FALSE,
  ncores = NULL
)
}
\arguments{
\item{ano}{A numerical array of anomalies with named dimensions to calculate
REOF then the four teleconnections. The dimensions must have at least 
'time_dim' and 'space_dim', and the data should cover the European Atlantic
Ocean area (20N-80N, 90W-60E).}

\item{lat}{A vector of the latitudes of 'ano'. It should be 20N-80N.}

\item{lon}{A vector of the longitudes of 'ano'. It should be 90W-60E.}

\item{ntrunc}{A positive integer of the modes to be kept. The default value 
is 30. If time length or the product of latitude length and longitude 
length is less than ntrunc, ntrunc is equal to the minimum of the three 
values.}

\item{time_dim}{A character string indicating the name of the time dimension
of 'ano'. The default value is 'sdate'.}

\item{space_dim}{A vector of two character strings. The first is the dimension
name of latitude of 'ano' and the second is the dimension name of longitude
of 'ano'. The default value is c('lat', 'lon').}

\item{corr}{A logical value indicating whether to base on a correlation (TRUE)
or on a covariance matrix (FALSE). The default value is FALSE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing:
\item{patterns}{
 An array of the first four REOF patterns normalized to 1 (unitless) with 
 dimensions (modes = 4, the rest of the dimensions of 'ano' except 
 'time_dim'). The modes represent NAO, EA, EAWR, and SCA, of which the order
 and sign changes depending on the dataset and period employed, so manual
 reordering  may be needed. Multiplying 'patterns' by 'indices' gives the 
 original reconstructed field.
}
\item{indices}{
 An array of the first four principal components with the units of the 
 original field to the power of 2, with dimensions (time_dim, modes = 4, the
 rest of the dimensions of 'ano' except 'space_dim'). 
} 
\item{var}{
 An array of the percentage (%) of variance fraction of total variance 
 explained by each mode. The dimensions are (modes = ntrunc, the rest of the
 dimensions of 'ano' except 'time_dim' and 'space_dim').
}
\item{wght}{
 An array of the area weighting with dimensions 'space_dim'. It is calculated
 by the square root of cosine of 'lat' and used to compute the fraction of 
 variance explained by each REOFs.
}
}
\description{
Calculate the four main teleconnection indices in European Atlantic Ocean 
region: North Atlantic oscillation (NAO), East Atlantic Pattern (EA), East
Atlantic/Western Russia (EAWR), and Scandinavian pattern (SCA). The function
\code{REOF()} is used for the calculation, and the first four modes are 
returned.
}
\examples{
# Use synthetic data
set.seed(1)
dat <- array(rnorm(800), dim = c(dat = 2, sdate = 5, lat = 8, lon = 15))
lat <- seq(10, 90, length.out = 8)
lon <- seq(-100, 70, length.out = 15)
res <- EuroAtlanticTC(dat, lat = lat, lon = lon)

}
\seealso{
REOF NAO
}
