% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/java.R
\name{java}
\alias{java}
\title{System Command to Run Java}
\usage{
java()
}
\value{
The system command needed to invoke Java, as a string.
}
\description{
Gets the system command needed to run Java from the command line, as a string.
Typically, this is the string: 'java'. 
However, if the R session has the \code{JAVA_HOME} environmental variable set, it will use that to locate java instead. 
This can be persisted over sessions (see the Details below).
}
\section{Details}{

This function is used by all of the \code{tika()} functions internally as the default value to its \code{java} parameter. 

This function tries to find an environmental variable using \code{Sys.getenv("JAVA_HOME")}.
It looks for the \code{java} executable inside the \code{bin} directory in the \code{JAVA_HOME} directory.

If you want to use a specific version of Java, set the \code{JAVA_HOME} variable using \code{Sys.setenv(JAVA_HOME = 'my path')},
where 'my path' is the path to a folder that has a \code{bin} directory with a \code{java} executable. 

For example, on Windows 11 \code{JAVA_HOME} might be \code{C:/Program Files/Java/jdk-21}. 
On Ubuntu and macOS, it might be something like \code{/usr/lib/jvm/temurin-21-jdk}.  

The \code{JAVA_HOME} variable can also be set to persist over sessions.
Add the path to the \code{.Rprofile} by adding \code{Sys.setenv(JAVA_HOME = 'my path')}, and it will use that every time R is started.
}

\examples{
\donttest{
# Typically, this function returns the string 'java'.
# If JAVA_HOME is set, it's a path to java in a 'bin' folder.
java()
}
}
