% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printCmd.R
\name{printCmd}
\alias{printCmd}
\alias{printCmd,Session-method}
\alias{printCmd,missingOrNULLOrChar-method}
\title{Retrieves printCmd setting of a Session}
\usage{
printCmd(session = NULL)

\S4method{printCmd}{Session}(session = NULL)

\S4method{printCmd}{missingOrNULLOrChar}(session = NULL)
}
\arguments{
\item{session}{Session object or character. The Session or path
to a Session where the printCmd settings are retrieved from. If \code{NULL} (default),
\code{session()} will be used}
}
\value{
A logical : \code{TRUE} if the session is configured to print commands and
\code{FALSE} if it is not.
}
\description{
Retrieves a printCmd setting of a \code{\link{Session-class}} object. The printCmd
setting configures a Session for printing commands sent to the console.
}
\examples{
\dontrun{
# Set SyncroSim Session
mySession <- session()

# Retrieve printCmd settings for given Session
printCmd(mySession)
}

}
