% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{sparql_query}
\alias{sparql_query}
\title{Execute a SPARQL Query}
\usage{
sparql_query(store, query)
}
\arguments{
\item{store}{An RDF store handle}

\item{query}{A SPARQL query string}
}
\value{
For SELECT queries, a data.frame with results. For ASK queries, a logical.
For CONSTRUCT/DESCRIBE queries, a data.frame with subject, predicate, object columns.
}
\description{
Executes a SPARQL query against the RDF store.
}
\examples{
store <- rdf_store()
rdf_load(store, '<http://example.org/s> <http://example.org/p> "hello" .', format = "ntriples")
sparql_query(store, "SELECT * WHERE { ?s ?p ?o }")
}
