% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.robpolyserial}
\alias{vcov.robpolyserial}
\title{Obtain estimated asymptotic variance-covariance matrix}
\usage{
\method{vcov}{robpolyserial}(object, ...)
}
\arguments{
\item{object}{Object of class \code{"robpolyserial"} or \code{"polyserial"}.}

\item{...}{Additional parameters to be passed down.}
}
\value{
A numeric matrix, being the estimated asymptotic covariance matrix for the model parameters
}
\description{
Estimate asymptotic variance-covariance matrix of polyserial model.
}
\details{
Method for classes \code{"robpolyserial"} and \code{"polyserial"}. Returns the estimated asymptotic variance-covariance matrix of a point estimate \code{thetahat}. The matrix \eqn{\Sigma} in the paper (asymptotic variance-covariance matrix of \eqn{\sqrt{N} \hat{\theta}}) can be obtained via multiplying the returned matrix by the sample size.
}
\examples{
## example data
set.seed(123)
x <- rnorm(n = 100)
y <- sample(c(1,2), size = 100, replace = TRUE)

fit <- polyserial(x,y)
vcov(fit)

}
