% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{ts_adjust}
\alias{ts_adjust}
\title{Multiplicative adjustment of a time series for leap year / length of periods}
\usage{
ts_adjust(s, method = c("LeapYear", "LengthOfPeriod"), reverse = FALSE)
}
\arguments{
\item{s}{The original time series}

\item{method}{\code{"LeapYear"}: correction for leap year
\code{"LengthOfPeriod"}: correction for the length of periods}

\item{reverse}{Adjustment or reverse operation}
}
\value{
The interpolated series
}
\description{
Multiplicative adjustment of a time series for leap year / length of periods
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
y <- ABS$X0.2.09.10.M
ts_adjust(y)
# with reverse we can find the
all.equal(ts_adjust(ts_adjust(y), reverse = TRUE), y)
\dontshow{\}) # examplesIf}
}
