% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{to_tscollection}
\alias{to_tscollection}
\title{Creates a collection of time series}
\usage{
to_tscollection(source, id, type = "All")
}
\arguments{
\item{source}{Source of the collection of time series}

\item{id}{Identifier of the collection of time series (source-dependent)}

\item{type}{Type of the requested information (Data, Metadata...).
All by default.}
}
\value{
An object of type "JD3_TSCOLLECTION". List containing the identifiers,
the metadata and all the series (data).
}
\description{
Creates a collection of time series
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# id is split due to length restrictions
id1 <- "demetra://tsprovider/Txt/20111201/SERIES?datePattern=dd\%2FMM\%2Fyyyy&delimiter=SEMICOLON&"
id2 <- "file=C\%3A\%5CDocuments\%5CIPI\%5CData\%5CIPI_nace4.csv#seriesIndex=0"
id <- paste0(id1, id2)
source <- "Txt"
my_collection <- to_tscollection(source, id)
\dontshow{\}) # examplesIf}
}
