% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{arima_difference}
\alias{arima_difference}
\title{Remove an arima model from an existing one.}
\usage{
arima_difference(left, right, simplify = TRUE)
}
\arguments{
\item{left}{Left operand (JD3_ARIMA object)}

\item{right}{Right operand (JD3_ARIMA object)}

\item{simplify}{Simplify the results if possible (common roots in the
auto-regressive and in the moving average polynomials, including unit roots)}
}
\value{
a \code{"JD3_ARIMA"} model.
}
\description{
More exactly, m_diff = m_left - m_right iff m_left = m_right + m_diff.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
mod1 <- arima_model(delta = c(1, -2, 1))
mod2 <- arima_model(variance = .01)
diff <- arima_difference(mod1, mod2)
sum <- arima_sum(diff, mod2)
# sum should be equal to mod1
\dontshow{\}) # examplesIf}
}
