/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarUtility;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GenericTradingDaysFactory
implements RegressionVariableFactory<GenericTradingDaysVariable> {
    private static final Map<Entry, Data> CACHE = new HashMap<Entry, Data>();
    public static GenericTradingDaysFactory FACTORY = new GenericTradingDaysFactory();
    private static final double[] MDAYS = new double[]{31.0, 28.25, 31.0, 30.0, 31.0, 30.0, 31.0, 31.0, 30.0, 31.0, 30.0, 31.0};
    private static final int DAY_OF_WEEK_OF_EPOCH = TsPeriod.DEFAULT_EPOCH.getDayOfWeek().getValue() - 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FastMatrix dataFor(DayClustering clustering, TsDomain domain) {
        Map<Entry, Data> map = CACHE;
        synchronized (map) {
            TsPeriod mstart;
            TsPeriod start = domain.getStartPeriod();
            Entry entry = new Entry(clustering, domain.getAnnualFrequency());
            Data rslt = CACHE.get(entry);
            if (rslt == null) {
                FastMatrix m = GenericTradingDaysFactory.generateContrasts(clustering, domain);
                CACHE.put(entry, new Data(start, m));
                return m;
            }
            int beg = rslt.start.until(start);
            int n = domain.getLength();
            int ng = rslt.data.getColumnsCount();
            int end = beg + n;
            if (beg >= 0 && end <= rslt.data.getRowsCount()) {
                return rslt.data.extract(beg, n, 0, ng);
            }
            int n0 = 0;
            int n1 = 0;
            int ncur = rslt.data.getRowsCount();
            if (beg < 0) {
                n0 = -beg;
                beg = 0;
                mstart = start;
            } else {
                mstart = rslt.start;
            }
            if (end > ncur) {
                n1 = end - ncur;
            }
            int nn = n0 + n1 + ncur;
            FastMatrix m = FastMatrix.make(nn, ng);
            MatrixWindow mw = m.top(0);
            if (n0 > 0) {
                TsDomain d0 = TsDomain.of((TsPeriod)start, (int)n0);
                mw.vnext(n0).copy(GenericTradingDaysFactory.generateContrasts(clustering, d0));
            }
            mw.vnext(ncur).copy(rslt.data);
            if (n1 > 0) {
                TsDomain d1 = TsDomain.of((TsPeriod)mstart.plus((long)(n0 + ncur)), (int)n1);
                mw.vnext(n1).copy(GenericTradingDaysFactory.generateContrasts(clustering, d1));
            }
            CACHE.put(entry, new Data(mstart, m));
            return m.extract(beg, n, 0, ng);
        }
    }

    private GenericTradingDaysFactory() {
    }

    @Override
    public boolean fill(GenericTradingDays var, TsPeriod start, FastMatrix buffer) {
        if (var.isContrast()) {
            this.dataContrast(var.getClustering(), start, buffer);
        } else {
            this.dataNoContrast(var.getClustering(), false, start, buffer);
        }
        return true;
    }

    @Override
    public boolean fill(GenericTradingDaysVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        this.dataContrast(var.getClustering(), start, buffer);
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(GenericTradingDaysVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void dataNoContrast(DayClustering clustering, boolean meanCorrected, TsPeriod start, FastMatrix buffer) {
        int i;
        int n = buffer.getRowsCount();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)n);
        int[][] days = GenericTradingDaysFactory.tdCount(domain);
        double[] mdays = meanCorrected ? GenericTradingDaysFactory.meanDays(domain) : null;
        int[][] groups = clustering.allPositions();
        int ng = groups.length;
        DoubleSeqCursor.OnMutable[] cells = new DoubleSeqCursor.OnMutable[ng];
        for (i = 0; i < cells.length; ++i) {
            cells[i] = buffer.column(i).cursor();
        }
        for (i = 0; i < n; ++i) {
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                int sum = days[group[0]][i];
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += days[group[ip]][i];
                }
                double dsum = sum;
                if (mdays != null) {
                    dsum -= (double)np * mdays[i];
                }
                cells[ig].setAndNext(dsum);
            }
        }
    }

    private void dataContrast(DayClustering clustering, TsPeriod start, FastMatrix buffer) {
        FastMatrix m = GenericTradingDaysFactory.dataFor(clustering, TsDomain.of((TsPeriod)start, (int)buffer.getRowsCount()));
        buffer.copy(m);
    }

    private static FastMatrix generateContrasts(DayClustering clustering, TsDomain domain) {
        int i;
        int n = domain.length();
        int[][] days = GenericTradingDaysFactory.tdCount(domain);
        int[][] groups = clustering.allPositions();
        GenericTradingDaysFactory.rotate(groups);
        int ng = groups.length - 1;
        int[] cgroup = groups[ng];
        DoubleSeqCursor.OnMutable[] cells = new DoubleSeqCursor.OnMutable[ng];
        FastMatrix data = FastMatrix.make(n, ng);
        for (i = 0; i < cells.length; ++i) {
            cells[i] = data.column(i).cursor();
        }
        for (i = 0; i < n; ++i) {
            int csum = days[cgroup[0]][i];
            int cnp = cgroup.length;
            for (int ip = 1; ip < cnp; ++ip) {
                csum += days[cgroup[ip]][i];
            }
            double dcsum = csum;
            dcsum /= (double)cnp;
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                int sum = days[group[0]][i];
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += days[group[ip]][i];
                }
                double dsum = sum;
                cells[ig].setAndNext(dsum - (double)np * dcsum);
            }
        }
        return data;
    }

    public static FastMatrix generateContrasts(DayClustering clustering, FastMatrix days) {
        FastMatrix m = FastMatrix.make(days.getRowsCount(), clustering.getGroupsCount() - 1);
        GenericTradingDaysFactory.fillContrasts(clustering, days, m, null);
        return m;
    }

    private static double weight(int[] group, double[] w) {
        double s = 0.0;
        for (int i = 0; i < group.length; ++i) {
            s += w[group[i]];
        }
        return s;
    }

    public static void fillContrasts(DayClustering clustering, FastMatrix days, FastMatrix data, double[] weights) {
        int n = days.getRowsCount();
        int[][] groups = clustering.allPositions();
        GenericTradingDaysFactory.rotate(groups);
        int ng = groups.length - 1;
        int[] cgroup = groups[ng];
        DoubleSeqCursor.OnMutable[] cells = new DoubleSeqCursor.OnMutable[ng];
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = data.column(i).cursor();
        }
        double[] w = new double[ng];
        if (weights == null) {
            denom = cgroup.length;
            for (ig = 0; ig < ng; ++ig) {
                w[ig] = (double)groups[ig].length / denom;
            }
        } else {
            denom = GenericTradingDaysFactory.weight(cgroup, weights);
            for (ig = 0; ig < ng; ++ig) {
                w[ig] = GenericTradingDaysFactory.weight(groups[ig], weights) / denom;
            }
        }
        for (int i = 0; i < n; ++i) {
            DataBlock rdays = days.row(i);
            double csum = rdays.get(cgroup[0]);
            int cnp = cgroup.length;
            for (int ip = 1; ip < cnp; ++ip) {
                csum += rdays.get(cgroup[ip]);
            }
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                double sum = rdays.get(group[0]);
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += rdays.get(group[ip]);
                }
                double dsum = sum;
                double val = dsum - w[ig] * csum;
                double ival = Math.round(val);
                if (Math.abs(val - ival) < 1.0E-9) {
                    val = ival;
                }
                cells[ig].setAndNext(val);
            }
        }
    }

    public static FastMatrix generateNoContrast(DayClustering clustering, TsPeriod start, FastMatrix days) {
        FastMatrix m = FastMatrix.make(days.getRowsCount(), clustering.getGroupsCount());
        GenericTradingDaysFactory.fillNoContrasts(clustering, start, days, m);
        return m;
    }

    public static FastMatrix fillNoContrasts(DayClustering clustering, TsPeriod start, FastMatrix days, FastMatrix data) {
        int i;
        int n = days.getRowsCount();
        double[] mdays = null;
        if (start != null) {
            TsDomain domain = TsDomain.of((TsPeriod)start, (int)n);
            mdays = GenericTradingDaysFactory.meanDays(domain);
        }
        int[][] groups = clustering.allPositions();
        int ng = groups.length;
        DoubleSeqCursor.OnMutable[] cells = new DoubleSeqCursor.OnMutable[ng];
        for (i = 0; i < cells.length; ++i) {
            cells[i] = data.column(i).cursor();
        }
        for (i = 0; i < n; ++i) {
            DataBlock rdays = days.row(i);
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                double sum = rdays.get(group[0]);
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += rdays.get(group[ip]);
                }
                double dsum = sum;
                if (mdays != null) {
                    dsum -= (double)np * mdays[i];
                }
                cells[ig].setAndNext(dsum);
            }
        }
        return data;
    }

    public static void fillNoContrasts(DayClustering clustering, FastMatrix days, FastMatrix output) {
        int[][] groups = clustering.allPositions();
        for (int ig = 0; ig < groups.length; ++ig) {
            int[] group = groups[ig];
            DataBlock column = output.column(ig);
            for (int j = 0; j < group.length; ++j) {
                column.add(days.column(group[j]));
            }
        }
    }

    private static void rotate(int[][] groups) {
        int[] cgroup = groups[0];
        for (int i = 1; i < groups.length; ++i) {
            groups[i - 1] = groups[i];
        }
        groups[groups.length - 1] = cgroup;
    }

    public static int[][] tdCount(TsDomain domain) {
        int i;
        int[][] rslt = new int[7][];
        int n = domain.length();
        int[] start = new int[n + 1];
        LocalDate cur = domain.start().toLocalDate();
        int conv = TsUnit.P1M.ratioOf(domain.getStartPeriod().getUnit());
        int year = cur.getYear();
        int month = cur.getMonthValue();
        for (i = 0; i < start.length; ++i) {
            start[i] = GenericTradingDaysFactory.calc(year, month, 1);
            if ((month += conv) <= 12) continue;
            ++year;
            month -= 12;
        }
        for (int j = 0; j < 7; ++j) {
            rslt[j] = new int[n];
        }
        for (i = 0; i < n; ++i) {
            int ni = start[i + 1] - start[i];
            int dw0 = (start[i] + DAY_OF_WEEK_OF_EPOCH) % 7;
            if (dw0 < 0) {
                dw0 += 7;
            }
            for (int j = 0; j < 7; ++j) {
                int j0 = j - dw0;
                if (j0 < 0) {
                    j0 += 7;
                }
                rslt[j][i] = 1 + (ni - 1 - j0) / 7;
            }
        }
        return rslt;
    }

    @Deprecated
    public static void fillTradingDaysMatrix(TsPeriod start, FastMatrix mtd) {
        GenericTradingDaysFactory.fillTradingDaysMatrix(start, false, mtd);
    }

    public static void fillTradingDaysMatrix(TsPeriod start, boolean corrected, FastMatrix mtd) {
        int[][] td = GenericTradingDaysFactory.tdCount(TsDomain.of((TsPeriod)start, (int)mtd.getRowsCount()));
        for (int i = 0; i < 7; ++i) {
            int[] curtd = td[i];
            mtd.column(i).set(k -> curtd[k]);
        }
        if (corrected) {
            int period = start.annualFrequency();
            double[] means = GenericTradingDaysFactory.meanDays(period);
            int pos = start.annualPosition();
            for (int r = 0; r < mtd.getRowsCount(); ++r) {
                mtd.row(r).sub(means[pos]);
                if (++pos != period) continue;
                pos = 0;
            }
        }
    }

    public static double[] meanDays(int period) {
        int conv = 12 / period;
        double[] m = new double[period];
        int k = 0;
        for (int i = 0; i < period; ++i) {
            double s = 0.0;
            int j = 0;
            while (j < conv) {
                s += MDAYS[k];
                ++j;
                ++k;
            }
            m[i] = s / 7.0;
        }
        return m;
    }

    public static double[] meanDays(TsDomain domain) {
        TsPeriod start = domain.getStartPeriod();
        int p = start.annualFrequency();
        double[] meanDays = GenericTradingDaysFactory.meanDays(p);
        int pos = start.annualPosition();
        double[] m = new double[domain.getLength()];
        for (int i = 0; i < m.length; ++i) {
            m[i] = meanDays[pos];
            if (++pos != p) continue;
            pos = 0;
        }
        return m;
    }

    private static int calc(int year, int month, int day) {
        boolean bLeapYear = CalendarUtility.isLeap((int)year);
        int nDate = year * 365 + year / 4 - year / 100 + year / 400 + CalendarUtility.getCumulatedMonthDays((int)(month - 1)) + day;
        if (month < 3 && bLeapYear) {
            --nDate;
        }
        return nDate - 719528;
    }

    private static final class Entry {
        private final DayClustering clustering;
        private final int period;

        @Generated
        public Entry(DayClustering clustering, int period) {
            this.clustering = clustering;
            this.period = period;
        }

        @Generated
        public DayClustering getClustering() {
            return this.clustering;
        }

        @Generated
        public int getPeriod() {
            return this.period;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (this.getPeriod() != other.getPeriod()) {
                return false;
            }
            DayClustering this$clustering = this.getClustering();
            DayClustering other$clustering = other.getClustering();
            return !(this$clustering == null ? other$clustering != null : !this$clustering.equals(other$clustering));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPeriod();
            DayClustering $clustering = this.getClustering();
            result = result * 59 + ($clustering == null ? 43 : $clustering.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "GenericTradingDaysFactory.Entry(clustering=" + String.valueOf(this.getClustering()) + ", period=" + this.getPeriod() + ")";
        }
    }

    private static final class Data {
        private final TsPeriod start;
        private final FastMatrix data;

        @Generated
        public Data(TsPeriod start, FastMatrix data) {
            this.start = start;
            this.data = data;
        }

        @Generated
        public TsPeriod getStart() {
            return this.start;
        }

        @Generated
        public FastMatrix getData() {
            return this.data;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            TsPeriod this$start = this.getStart();
            TsPeriod other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            FastMatrix this$data = this.getData();
            FastMatrix other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TsPeriod $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            FastMatrix $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "GenericTradingDaysFactory.Data(start=" + String.valueOf(this.getStart()) + ", data=" + String.valueOf(this.getData()) + ")";
        }
    }
}

