/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.calendars;

import internal.xml.calendars.DayAdapterLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.xml.legacy.calendars.HolidayAdapter;
import jdplus.toolkit.base.xml.legacy.calendars.XmlDay;

public class HolidayAdapters {
    private static final AtomicReference<HolidayAdapters> defadapters = new AtomicReference();
    private final List<HolidayAdapter> adapters = new ArrayList<HolidayAdapter>();

    public static final HolidayAdapters getDefault() {
        defadapters.compareAndSet(null, HolidayAdapters.make());
        return defadapters.get();
    }

    public static final void setDefault(HolidayAdapters adapters) {
        defadapters.set(adapters);
    }

    private static HolidayAdapters make() {
        HolidayAdapters adapters = new HolidayAdapters();
        adapters.load();
        return adapters;
    }

    public void load() {
        this.adapters.addAll(new DayAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public Holiday unmarshal(XmlDay xvar) {
        for (HolidayAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (Holiday)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlDay marshal(Holiday ivar) {
        for (HolidayAdapter adapter : this.adapters) {
            if (!adapter.getValueType().isInstance(ivar)) continue;
            try {
                return (XmlDay)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

