/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.fixme;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ResourceWatcher {
    private final List<Id> resources = new ArrayList<Id>();
    private int count = 0;

    public boolean isLeaking() {
        return !this.resources.isEmpty();
    }

    @NonNull
    public Id watch(@NonNull String name) {
        Objects.requireNonNull(name);
        Id result = new Id(name, this.count++);
        this.resources.add(result);
        return result;
    }

    public void unwatch(@NonNull Id id) {
        Objects.requireNonNull(id);
        if (!this.resources.remove(id)) {
            throw new IllegalArgumentException(id.toString());
        }
    }

    @NonNull
    public Closeable watchAsCloseable(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Id id = this.watch(name);
        return () -> this.unwatch(id);
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    public static final class Id {
        private final String name;
        private final int cpt;

        @Generated
        public Id(String name, int cpt) {
            this.name = name;
            this.cpt = cpt;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getCpt() {
            return this.cpt;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (this.getCpt() != other.getCpt()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCpt();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ResourceWatcher.Id(name=" + this.getName() + ", cpt=" + this.getCpt() + ")";
        }
    }
}

