% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rice.R
\name{howmuchC14}
\alias{howmuchC14}
\title{Amount of C14 particles in a sample}
\usage{
howmuchC14(
  age,
  wght = 1,
  use.cc = TRUE,
  Av = 6.02214076e+23,
  C14.1950 = 1.176e-12,
  current = 2.5e-05,
  format = "g",
  cc = 1,
  postbomb = FALSE,
  cc.dir = NULL,
  thiscurve = NULL,
  talk = TRUE,
  decimals = 3
)
}
\arguments{
\item{age}{The age of the sample (in cal BP per default, or in C14 BP is use.cc=FALSE).}

\item{wght}{The weight of the sample (in mg). Defaults to 1 mg.}

\item{use.cc}{Whether or not to use the calibration curve. If set to \code{use.cc=FALSE}, then we assume that the age is the radiocarbon age (this enables ages beyond the reach of the calibration curves to be used).}

\item{Av}{Avogadro's number, used to calculate the number of carbon atoms in the sample.}

\item{C14.1950}{The standard 14C/C ratio back in AD 1950 (1.176e-12, so around 1 in 1 trillion carbon atoms was a 14C atom at that moment in time.}

\item{current}{The current of 12C+ ions arriving at the Faraday counter. Defaults to \code{current=25e-6}, 25 micro-Ampere.}

\item{format}{The format of the printed numbers. Defaults to either scientific (for large numbers) or as fixed-point, depending on the size of the number.}

\item{cc}{calibration curve for C14 (see \code{caldist()}).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{talk}{Whether or not to provide feedback (defaults to TRUE).}

\item{decimals}{Number of decimals to be returned for F and atom counts.}
}
\value{
The estimated number of C14 atoms.
}
\description{
Calculate the expected amount of remaining C14 atoms in a sample, given its weight and age.
}
\details{
The number of carbon atoms in the sample is estimated. Given the known C14/C ratio at F=1, and given the sample's age, we can estimate the number of remaining C14 atoms. Given a 12C current at the detector end of an AMS, we can then also calculate how many 14C ions would be counted per second and minute. 
Note that backgrounds are not modelled (but could be investigated by e.g. typing \code{howmuchC14(45e3)} which gives as c. 1 background count per second).
}
\examples{
  howmuchC14(0) # recent sample
  howmuchC14(55e3) # at dating limit
  howmuchC14(145e3) # way beyond the dating limit, 1 C14 atom per mg remains
}
\author{
Maarten Blaauw
}
