% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pScore.R
\name{pQnormScore}
\alias{pQnormScore}
\title{Transform p-values to continuous scores with the quantile function of the normal distribution}
\usage{
pQnormScore(p, sign = 1, replaceZero = TRUE)
}
\arguments{
\item{p}{\emph{p}-value(s) between \eqn{(0,1]}}

\item{sign}{Signs of the scores, either positive (in case of positive numbers),
negative (in case of negative numbers), or zero. In case of a logical vector,
\code{TRUE} is interpreted as positive and \code{FALSE} is interpreted as negative.}

\item{replaceZero}{Logical, whether to replace zero p-values with the 
minimal double value specified by the machine. Default is \code{TRUE}. If 
set to \code{FALSE}, results will contain infinite values.}
}
\value{
A numeric vector of transformed p-values using signed quantile normal transformation.
}
\description{
Quantile function, also known as the inverse of cumulative distribution function of the normal 
distribution, is used to map p-values to continuous scores raging on \eqn{R}. The signs of the 
resulting scores are positive by default and are determined by the parameter \code{sign}.
}
\examples{
testPvals <- c(0.001, 0.01, 0.05, 0.1, 0.5, 1)
pQnormScore(testPvals)
testPvalSign <- rep(c(-1,1), 3)
pQnormScore(testPvals, sign=testPvalSign)
testLog <- rep(c(TRUE, FALSE),3)
pQnormScore(testPvals, testLog)

}
\seealso{
\code{\link{pAbsLog10Score}}, \code{\link{pScore}}, \code{\link{double}}
}
