% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{cbindByRownames}
\alias{cbindByRownames}
\alias{rbindByColnames}
\title{Column bind by rownames}
\usage{
cbindByRownames(..., type = c("intersect", "union"))

rbindByColnames(..., type = c("intersect", "union"))
}
\arguments{
\item{...}{Two or more matrices, or a list of matrices.}

\item{type}{Character string, how are row names that are not shared by all
items handled, either \code{intersect} (intersect are kept) or \code{union}
(union is used, \code{NA} is inserted whenever necessary)}
}
\value{
A \code{matrix}
}
\description{
Column bind by rownames
}
\examples{
mat1 <- matrix(1:9, nrow=3, byrow=FALSE,
               dimnames=list(LETTERS[1:3], LETTERS[1:3]))
mat2 <- matrix(1:9, nrow=3, byrow=FALSE,
               dimnames=list(LETTERS[2:4], LETTERS[4:6]))
mat3 <- matrix(1:9, nrow=3, byrow=FALSE,
               dimnames=list(LETTERS[c(2,4,5)], LETTERS[7:9]))
cbindByRownames(mat1, mat2, mat3, type="intersect")
cbindByRownames(mat1, mat2, mat3, type="union")
## it is also possible to pass a list
cbindByRownames(list(mat1, mat2, mat3), type="union")
mat4 <- matrix(1:9, nrow=3, byrow=FALSE,
               dimnames=list(LETTERS[1:3], LETTERS[1:3]))
mat5 <- matrix(1:9, nrow=3, byrow=FALSE,
               dimnames=list(LETTERS[4:6], LETTERS[2:4]))
mat6 <- matrix(1:9, nrow=3, byrow=TRUE,
               dimnames=list(LETTERS[7:9], LETTERS[c(2,4,6)]))
rbindByColnames(mat4, mat5, mat6, type="intersect")
rbindByColnames(mat4, mat5, mat6,  type="union")
## it is also possible to pass a list
rbindByColnames(list(mat4, mat5, mat6), type="union")
}
