% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rowKappa}
\alias{rowKappa}
\title{Calculate row-wise kappa statistics of a matrix}
\usage{
rowKappa(matrix, minOverlap = 0L)
}
\arguments{
\item{matrix}{An adjacency matrix, containing values of either 0 or 1.}

\item{minOverlap}{Integer, minimal overlap between two columns in order to be considered. Pairs with fewer overlaps will return \code{NA}.}
}
\value{
A matrix of size \eqn{m \times m} if the input matrix is of size \eqn{m \times n}.
}
\description{
The function returns row-wise kappa statistics of a matrix, using a linear algebra procedure implemented in C++.
}
\note{
A kappa statistics of value 1 indicates perfect agreement. A value of 0
indicates no agreement. Note that the value can be negative, which implies
the agreement is worse than random.
}
\examples{
testMat <- cbind(c(1,1,0,0,1,0), c(1,1,0,1,1,0), c(0,1,0,0,1,0), c(1,0,1,0,1,0))
rowKappa(testMat)
stopifnot(identical(rowKappa(testMat), colKappa(t(testMat))))
}
\seealso{
\code{\link{colKappa}} to calculate the statistic of rows

Other kappa functions: 
\code{\link{colKappa}()},
\code{\link{kappaSimp}()}
}
\concept{kappa functions}
