% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/davidClustering_kappa_R.R
\name{davidClustering_kappa_R}
\alias{davidClustering_kappa_R}
\title{Cluster rows of a Kappa-statistic-matrix by the hierarhical fuzzy multi-linkage partitioning method proposed by DAVID}
\usage{
davidClustering_kappa_R(
  kappaMatrix,
  kappaThr = 0.35,
  initialGroupMembership = 3,
  multiLinkageThr = 0.5,
  removeRedundant = TRUE,
  debug = FALSE
)
}
\arguments{
\item{kappaMatrix}{A numeric matrix of Kappa statistics, which is likely returned by \code{\link{rowKappa}} or \code{\link{colKappa}}.}

\item{kappaThr}{Numeric, the threshold of the Kappa statistic, which is used to select initial seeds. Default value: 0.35, as recommended by the authors of the original study based on their experiences.}

\item{initialGroupMembership}{Integer, the number of minimal members in initial groups. Default value: 3.}

\item{multiLinkageThr}{Numeric, the minimal linkage between two groups to be merged. Default value: 0.5.}

\item{removeRedundant}{Logical, whether redundant initial groups should be removed before clustering. Used for debugging. Setting as \code{TRUE} accelerates the iterative clustring process.}

\item{debug}{Logical, whether seed information is printed for debugging purposes.}
}
\description{
The function implements the Hierarhical fuzzy multi-linkage partitioning method used in the DAVID Bioinformatics tool.
}
\note{
The function has only been tested in a few anecdotal examples. Cautions and more systematic tests are required before it is applied to critical datasets.
}
\references{
Huang et al. The DAVID Gene Functional Classification Tool: a novel
biological module-centric algorithm to functionally analyze large gene
lists. Genome Biology, 2007. \doi{10.1186/gb-2007-8-9-r183}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
