% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeStrList.R
\name{writeStrList}
\alias{writeStrList}
\title{Write a list of strings in a tab-delimited file}
\usage{
writeStrList(
  list,
  file,
  names = NULL,
  type = c("column", "row"),
  index = FALSE
)
}
\arguments{
\item{list}{A list of character strings}

\item{file}{A filename}

\item{names}{Names of the list; by default the names of the list}

\item{type}{Should list items written in columns or rows?}

\item{index}{Logical, should integer index be printed along the elements?}
}
\value{
No return value, called for side effects (writes to file).
}
\description{
Write a list of strings in a tab-delimited file
}
\examples{
myList <- list("A"=LETTERS[3:5], "B"=LETTERS[4])
writeStrList(myList, file=stdout())
writeStrList(myList, file=stdout(), names=c("ListA", "ListB"))
writeStrList(myList, file=stdout(), names=c("ListA", "ListB"), type="row")
writeStrList(myList, file=stdout(), names=c("ListA", "ListB"), type="row", index=TRUE)
writeStrList(myList, file=stdout(), names=c("ListA", "ListB"), type="column", index=TRUE)
}
