% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite_graph.R
\name{bipartite_graph_from_data_frame}
\alias{bipartite_graph_from_data_frame}
\title{Create a bipartite graph from data frame}
\usage{
bipartite_graph_from_data_frame(x)
}
\arguments{
\item{x}{A \code{data.frame} with at least two columns.}
}
\value{
A \code{igraph} object that represents a bipartite graph. The \code{type} attribute of vertices is a logical vector that represents the two classes of nodes: nodes in the first column in the input \code{data.frame} are of the type \code{TRUE}, and those in the second column are of the type \code{FALSE}.

Extra columns besides the first two are used as edge attribtues. See example below.
}
\description{
Create a bipartite graph from data frame
}
\examples{
myDataFrame <- data.frame(Alpha=c("A", "E", "O", "U", "B", "D"), 
  Type=c("Vowel", "Vowel", "Vowel", "Vowel", "Consonance", "Consonance"))
myBpGraph <- bipartite_graph_from_data_frame(myDataFrame)

myDataFrame2 <- data.frame(Alpha=c("A", "E", "O", "U", "B", "D"), 
  Type=c("Vowel", "Vowel", "Vowel", "Vowel", "Consonance", "Consonance"),
  Example=c("BAT", "BED", "BOT", "BUT", "DUB", "DUB"))
myBpGraph2 <- bipartite_graph_from_data_frame(myDataFrame2)
igraph::E(myBpGraph2)$Example
}
