% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFuncs.R
\name{parseStrings}
\alias{parseStrings}
\title{Parse a character string into string vectors}
\usage{
parseStrings(str, collapse = ",", trim = TRUE, ...)
}
\arguments{
\item{str}{A character string to be parsed}

\item{collapse}{Character(s) used in the character string to concatenate strings}

\item{trim}{Logical, whether additional spaces should be trimmed}

\item{...}{Further parameters passed to \code{\link[ribiosUtils]{trim}} for fine-tuning of trimming}
}
\value{
A vector of character strings
}
\description{
This function parses collapsed multiple options into a vector of
character strings. Each option is optionally trimmed of leading and tailing empty
spaces given by \code{trim}. See examples.
}
\details{
In case of multiple separators, they can be given by concatenating
 with piple signs, e.g. \code{,|\\t}.
 If input string is \code{NULL}, the function returns \code{NULL}. This
 can be useful in case the parameter is optional and not specified.
}
\examples{
parseStrings("veni, vidi, vici")
parseStrings("veni, vidi, vici", trim=FALSE)
parseStrings("I came, I saw, I conquered")

# options are trimmed
parseStrings("a,b,\tc,d\n")
# it works also with only one option
parseStrings("a")
# more than one separators
parseStrings("a,b,c;d", collapse=",|;")
}
\seealso{
\code{\link{strsplit}}, \code{\link[ribiosUtils]{trim}}
}
