% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-reeb-graph.R
\name{as_reeb_graph}
\alias{as_reeb_graph}
\alias{as_reeb_graph.igraph}
\alias{as_reeb_graph.network}
\alias{as_igraph}
\alias{as_igraph.reeb_graph}
\alias{as_network}
\alias{as_network.reeb_graph}
\title{Coerce objects to class \code{reeb_graph}}
\usage{
as_reeb_graph(x, ...)

\method{as_reeb_graph}{igraph}(x, values = NULL, names = NULL, ...)

\method{as_reeb_graph}{network}(x, values = NULL, names = NULL, ...)

as_igraph(x, ...)

\method{as_igraph}{reeb_graph}(x, values = "value", names = "name", ...)

as_network(x, ...)

\method{as_network}{reeb_graph}(x, values = "value", names = "vertex.names", ...)
}
\arguments{
\item{x}{An R object to be coerced. See Details.}

\item{...}{Additional arguments passed to methods.}

\item{values}{For coercion \emph{to} class \code{reeb_graph}, a character value; the
node attribute to use as the Reeb graph value function. If \code{NULL} (the
default), the first numeric node attribute is used. For coercion \emph{from}
class \code{reeb_graph}, a character value; the name of the node attribute in
which to store the Reeb graph value function.}

\item{names}{For coercion \emph{to} class \code{reeb_graph}, a character value; the
node attribute to use as the Reeb graph node names. If \code{NULL}, names are
omitted. For coercion \emph{from} class \code{reeb_graph}, a character value; the
name of the node attribute in which to store the Reeb graph node names.}
}
\value{
A \link{reeb_graph} object.
}
\description{
Coerce objects to \verb{[reeb_graph]}-class objects.
}
\details{
The \code{as_reeb_graph()} methods require a network (mathematical graph)
structure and a real-valued function on the vertex set.

For coercion between external network classes, use the \code{intergraph}
package.
}
\examples{
\dontshow{if (rlang::is_installed("igraph")) withAutoprint(\{ # examplesIf}
library(igraph)
( g <- make_kautz_graph(2, 1) )
l_g <- layout_with_fr(g)
plot(g, layout = l_g)
( rg <- as_reeb_graph(g, l_g[, 1]) )
vertex_attr(g, "height") <- rg$value
heights <- sort(unique(V(g)$height))
l_rg <- layout_with_sugiyama(g, layers = round(V(g)$height * 100))
plot(g, layout = l_rg)
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("network")) withAutoprint(\{ # examplesIf}
library(network)
data("emon")
mtsi <- emon$Cheyenne
mtsi_reeb <- as_reeb_graph(
  mtsi,
  values = "Command.Rank.Score",
  names = "vertex.names"
)
print(mtsi_reeb, minlength = 24)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reeb_graph]{reeb_graph()}}
}
