% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{gd_band_properties}
\alias{gd_band_properties}
\title{Get Properties of Layers in an Earth Engine Image}
\usage{
gd_band_properties(x)
}
\arguments{
\item{x}{a \code{geedim.image.ImageAccessor} (for geedim >= 2.0.0) or \code{geedim.download.BaseImage} (for geedim < 2.0.0) object, such as from \code{gd_image_from_id()}. See \verb{\link{geedim-versions}} for more details.}
}
\value{
list. Each element is a list that corresponds to a layer in \code{x}, each with one or more elements for properties of that layer.
}
\description{
Gets combined Earth Engine and STAC properties.
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) && gd_is_initialized()) withAutoprint(\{ # examplesIf}
\donttest{
if (gd_is_initialized())
  gd_band_properties(gd_image_from_id("USGS/SRTMGL1_003"))
}
\dontshow{\}) # examplesIf}
}
