% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_plots.R
\name{refdb_plot_map}
\alias{refdb_plot_map}
\title{Plot an interactive map}
\usage{
refdb_plot_map(x)
}
\arguments{
\item{x}{a reference database.}
}
\value{
An interactive map object from the \pkg{leaflet} package.
}
\description{
This functions generate an interactive maps showing
the location of the records of a reference database.
Note that only records with
latitude and longitude data will be displayed.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
lib <- refdb_set_fields(lib, latitude = "lat", longitude = "lon")
refdb_plot_map(lib)

}
