% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{redist_ci}
\alias{redist_ci}
\alias{redist_smc_ci}
\alias{redist_mcmc_ci}
\title{Confidence Intervals for SMC and MCMC Estimates}
\usage{
redist_ci(plans, x, district = 1L, conf = 0.9, by_chain = FALSE)

redist_smc_ci(plans, x, district = 1L, conf = 0.9, by_chain = FALSE)

redist_mcmc_ci(plans, x, district = 1L, conf = 0.9, by_chain = FALSE)
}
\arguments{
\item{plans}{a \link{redist_plans} object.}

\item{x}{the quantity to build an interval for. Tidy-evaluated within \code{plans}.}

\item{district}{for \link{redist_plans} objects with multiple districts, which
\code{district} to subset to. Set to \code{NULL} to perform no subsetting.}

\item{conf}{the desired confidence level.}

\item{by_chain}{Whether the confidence interval should indicate overall
sampling uncertainty (\code{FALSE}) or per-chain sampling uncertainty (\code{TRUE}).
In the latter case the intervals will be wider by a factor of \code{sqrt(runs)}.}
}
\value{
A tibble with three columns: \code{X}, \code{X_lower}, and
\code{X_upper}, where \code{X} is the name of the vector of interest,
containing the mean and confidence interval. When used inside
\code{\link[dplyr:summarise]{summarize()}} this will create three columns in the
output data.
}
\description{
Builds a confidence interval for a quantity of interest.
If multiple runs are available, uses the between-run variation to estimate
the standard error. If only one run is available, uses information on the SMC
particle/plan genealogy to estimate the standard error, using a variant of
the method of Olson & Douc (2019). The multiple-run estimator is more
reliable, especially for situations with many districts, and should be used
when parallelism is available.  All reference plans are ignored.
}
\section{Functions}{
\itemize{
\item \code{redist_smc_ci()}: Compute confidence intervals for SMC output.

\item \code{redist_mcmc_ci()}: Compute confidence intervals for MCMC output.

}}
\examples{
library(dplyr)
data(iowa)

iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05)
plans <- redist_mergesplit_parallel(iowa_map, nsims = 200, chains = 2, silent = TRUE) \%>\%
    mutate(dem = group_frac(iowa_map, dem_08, dem_08 + rep_08)) \%>\%
    number_by(dem)
redist_smc_ci(plans, dem)

}
\references{
Lee, A., & Whiteley, N. (2018). Variance estimation in the particle filter.
Biometrika, 105(3), 609-625.

Olsson, J., & Douc, R. (2019). Numerically stable online estimation of
variance in particle filters. Bernoulli, 25(2), 1504-1535.

H. P. Chan and T. L. Lai. A general theory of particle filters in hidden
Markov models and some applications. Ann. Statist., 41(6):2877–2904, 2013.
}
\concept{analyze}
