% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdd_data_methods.R
\name{plot.rdd_data}
\alias{plot.rdd_data}
\title{Plot rdd_data}
\usage{
\method{plot}{rdd_data}(
  x,
  h = NULL,
  nbins = NULL,
  xlim = range(object$x, na.rm = TRUE),
  cex = 0.7,
  nplot = 1,
  device = c("base", "ggplot"),
  ...
)
}
\arguments{
\item{x}{Object of class rdd_data}

\item{h}{The binwidth parameter (note this differs from the bandwidth parameter!)}

\item{nbins}{Alternative to h, the total number of bins in the plot.}

\item{xlim}{The range of the x data}

\item{cex}{Size of the points, see \code{\link{par}}}

\item{nplot}{Number of plot to draw}

\item{device}{Type of device used. Currently not used.}

\item{\ldots}{Further arguments passed to the \code{\link{plot}} function.}
}
\value{
A plot
}
\description{
Binned plot of the forcing and outcome variable
}
\details{
Produces a simple binned plot averaging values within each interval. The length of the intervals
is specified with the argument \code{h}, specifying the whole binwidth (contrary to the usual bandwidth
argument, that gives half of the length of the kernel window. 
When no bandwidth is given, the bandwidth of Ruppert et al is used, see \code{\link{rdd_bw_rsw}}.
}
\examples{
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)
plot(house_rdd)

## Specify manually the bandwidth:
plot(house_rdd, h=0.2)

## Show three plots with different bandwidth:
plot(house_rdd, h=c(0.2,0.3,0.4), nplot=3)

## Specify instead of the bandwidth, the final number of bins:
plot(house_rdd, nbins=22)

## If the specified number of bins is odd, the larger number is given to side with largest range
plot(house_rdd, nbins=21)
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
