% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_updates.R
\name{rcatfish_updates}
\alias{rcatfish_updates}
\title{Access catalog changes and additions}
\usage{
rcatfish_updates(
  changes = TRUE,
  author.changes = TRUE,
  spell.changes = TRUE,
  added.genera = TRUE,
  added.species = TRUE
)
}
\arguments{
\item{changes}{Logical. Should the function return the table of changes to the catalog? Default is TRUE.}

\item{author.changes}{Logical. Should the function return the table of author and year changes to the catalog? Default is TRUE.}

\item{spell.changes}{Logical. Should the function return the table of spelling changes to the catalog? Default is TRUE.}

\item{added.genera}{Logical. Should the function return genera added to the catalog? Default is TRUE.}

\item{added.species}{Logical. Should the function return species added to the catalog? Default is TRUE.}
}
\value{
A named list. Names include UpdateDate, Changes, AuthorshipChanges, AddedGenera, and AddedSpecies. UpdateDate will always be returned and is a character string of the date the catalog was updated. Changes, AddedGenera, and AddedSpecies summarize changes to the catalog, changes to authorship information, genera added to the catalog, and species added to the catalog respectively. The elements returned are based on which parameters are set to TRUE. An itemized list describing the contents in the columns of the data returned is described below.
\itemize{
\item Original.Taxon - Character. The original taxonomic name in the database.
\item Was - Character. Previous status of the taxon in the database.
\item Previous.Taxon - Character. Previous taxonomic name in the database.
\item Now - Character. Current status of the taxon in the database following the update.
\item Current.Taxon - Character. Current taxonomic name in the database for the taxon following the update.
\item Taxon - Character. Taxon (of any rank) whose citation was updated.
\item Previous.Author - Character. Authorship information of the citation before the update.
\item Current.Author - Character. Authorship information of the citation following the update.
\item Species.Name - Character. Current taxonomic name in the database for the taxon following the update.
\item Genus.Name - Character. Name of the new genus added to the database following the update.
\item Authors - Character. Authorship for new taxonomic names added to the database following the update.
\item Year   - Character. Year for new taxonomic names added to the database following the update.
\item Region - Character. Region new taxa added to the database are known to occur in.
\item Was.Spelled - Character. Previous spelling of the taxon in the database.
\item Now.Spelled - Character. Revised spelling of the taxon in the database.
}
}
\description{
This function is used to access the Eschmeyer's Catalog of Fishes Summary of Changes and Additions.
}
\details{
This function displays the information on the "Changes and Additions" tab of Eschmeyer's Catalog of Fishes. The catalog updates this information monthly with changes to the catalog, new genus information, and new species information. Each updates removes the last month's information, so data obtained through this function is only representative of the changes and additions made since the previous update.
}
\examples{
# return all available data
myList <- rcatfish_updates(changes = TRUE, added.genera = TRUE, added.species = TRUE)
}
\references{
Fricke, R., van der Laan, R. & Fong, J.D. (Year Accessed). Eschmeyer’s Catalog of Fishes: Changes and Additions. https://researcharchive.calacademy.org/research/ichthyology/catalog/ChangeSummary.asp.
}
\author{
Brandon E. Dominy, Samuel R. Borstein
}
