#' Search the Catalog of Fishes in R
#'
#' @description Provides access to California Academy of Sciences Catalog of Fishes Database in R
#' @details 
#' Package: rcatfish
#' 
#' Type: Package
#' 
#' Title: Provides access to California Academy of Sciences Eschmeyer's Catalog of Fishes Database in R
#' 
#' Version: 1.0
#' 
#' 
#' License: GPL (>= 2)
#' 
#' This package allows user to query the California Academy of Sciences Eschmeyer's Catalog of Fishes through R.
#' Users can search for Genera, Species, and references, as well as query the number of species
#' described in each family or subfamily. A vignette going over the basic functions and
#' how to use them can be accessed with vignette("rcatfish-vignette").
#' 
#' @author Samuel Borstein, Brandon Dominy, Brian O'Meara.
#' Maintainer: Samuel Borstein <sam@borstein.com>
#' 
#' @seealso @seealso \code{\link{rcatfish_search}},\code{\link{rcatfish_references}},\code{\link{rcatfish_version}},\code{\link{rcatfish_collections}},\code{\link{rcatfish_classification}},\code{\link{rcatfish_glossary}},\code{\link{rcatfish_journals}},\code{\link{rcatfish_species_by}},\code{\link{rcatfish_updates}}
#' 
#' @name rcatfish
#"_PACKAGE"