% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{mcse_internal}
\alias{mcse_internal}
\alias{mcse_jackknife}
\alias{jackknife_se}
\alias{mcse_combine_all_pars}
\title{Internal MCSE Computations}
\usage{
mcse_jackknife(results, omit_index, conf.level, alternative)

jackknife_se(pars_jackknife)

mcse_combine_all_pars(jackknife_results)
}
\arguments{
\item{results}{an analysis object created by \code{\link[=analyse]{analyse()}}.}

\item{omit_index}{the index of the result to omit.}

\item{conf.level}{confidence level of the returned confidence interval.
Must be a single number between 0 and 1. Default is 0.95.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{pars_jackknife}{the numeric vector of the jackknife results.}

\item{jackknife_results}{the list of jackknife results of all parameters, in the same format as
the pooled parameter estimates.}
}
\description{
These functions are used by \code{\link[=mcse]{mcse()}} to compute the Monte Carlo standard error using the Jackknife approach.
}
