% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova.R
\name{ancova}
\alias{ancova}
\title{Analysis of Covariance}
\usage{
ancova(
  data,
  vars,
  visits = NULL,
  weights = c("counterfactual", "equal", "proportional_em", "proportional")
)
}
\arguments{
\item{data}{A \code{data.frame} containing the data to be used in the model.}

\item{vars}{A \code{vars} object as generated by \code{\link[=set_vars]{set_vars()}}. Only the \code{group},
\code{visit}, \code{outcome} and \code{covariates} elements are required. See details.}

\item{visits}{An optional character vector specifying which visits to
fit the ancova model at. If \code{NULL}, a separate ancova model will be fit to the
outcomes for each visit (as determined by \code{unique(data[[vars$visit]])}).
See details.}

\item{weights}{Character, either \code{"counterfactual"} (default), \code{"equal"},
\code{"proportional_em"} or \code{"proportional"}.
Specifies the weighting strategy to be used when calculating the lsmeans.
See the weighting section for more details.}
}
\description{
Performs an analysis of covariance between two groups returning the estimated
"treatment effect" (i.e. the contrast between the two treatment groups) and
the least square means estimates in each group.
}
\details{
The function works as follows:
\enumerate{
\item Select the first value from \code{visits}.
\item Subset the data to only the observations that occurred on this visit.
\item Fit a linear model as  \code{vars$outcome ~ vars$group + vars$covariates}.
\item Extract the "treatment effect" & least square means for each treatment group.
\item Repeat points 2-3 for all other values in \code{visits}.
}

If no value for \code{visits} is provided then it will be set to
\code{unique(data[[vars$visit]])}.

In order to meet the formatting standards set by \code{\link[=analyse]{analyse()}} the results will be collapsed
into a single list suffixed by the visit name, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
   trt_visit_1 = list(est = ...),
   lsm_ref_visit_1 = list(est = ...),
   lsm_alt_visit_1 = list(est = ...),
   trt_visit_2 = list(est = ...),
   lsm_ref_visit_2 = list(est = ...),
   lsm_alt_visit_2 = list(est = ...),
   ...
)
}\if{html}{\out{</div>}}

Please note that "ref" refers to the first factor level of \code{vars$group} which does not necessarily
coincide with the control arm. Analogously, "alt" refers to the second factor level of \code{vars$group}.
"trt" refers to the model contrast translating the mean difference between the second level and first level.

If you want to include interaction terms in your model this can be done
by providing them to the \code{covariates} argument of \code{\link[=set_vars]{set_vars()}}
e.g. \code{set_vars(covariates = c("sex*age"))}.
}
\section{Weighting}{

\subsection{Counterfactual}{

For \code{weights = "counterfactual"} (the default) the lsmeans are obtained by
taking the average of the predicted values for each patient after assigning all patients
to each arm in turn.
This approach is equivalent to standardization or g-computation.
In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", counterfactual = "<treatment>")
}\if{html}{\out{</div>}}

Note that to ensure backwards compatibility with previous versions of \code{rbmi}
\code{weights = "proportional"} is an alias for \code{weights = "counterfactual"}.
To get results consistent with \code{emmeans}'s \code{weights = "proportional"}
please use \code{weights = "proportional_em"}.
}

\subsection{Equal}{

For \code{weights = "equal"} the lsmeans are obtained by taking the model fitted
value of a hypothetical patient whose covariates are defined as follows:
\itemize{
\item Continuous covariates are set to \code{mean(X)}
\item Dummy categorical variables are set to \code{1/N} where \code{N} is the number of levels
\item Continuous * continuous interactions are set to \code{mean(X) * mean(Y)}
\item Continuous * categorical interactions are set to \code{mean(X) * 1/N}
\item Dummy categorical * categorical interactions are set to \code{1/N * 1/M}
}

In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", weights = "equal")
}\if{html}{\out{</div>}}
}

\subsection{Proportional}{

For \code{weights = "proportional_em"} the lsmeans are obtained as per \code{weights = "equal"}
except instead of weighting each observation equally they are weighted by the proportion
in which the given combination of categorical values occurred in the data.
In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", weights = "proportional")
}\if{html}{\out{</div>}}

Note that this is not to be confused with \code{weights = "proportional"} which is an alias
for \code{weights = "counterfactual"}.
}
}

\seealso{
\code{\link[=analyse]{analyse()}}

\code{\link[stats:lm]{stats::lm()}}

\code{\link[=set_vars]{set_vars()}}
}
