% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_methods.R
\name{summary.pool}
\alias{summary.pool}
\title{Summary Method for Pool Objects}
\usage{
\method{summary}{pool}(object, alpha = 0.05, ...)
}
\arguments{
\item{object}{An object of class \code{pool}, typically obtained from \code{\link[rbmi:pool]{rbmi::pool()}}.}

\item{alpha}{Numeric. Significance threshold for flagging p-values.
Default is 0.05. Flags are: \code{*} for p < alpha, \verb{**} for p < 0.01,
\verb{***} for p < 0.001.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns a list with:
\describe{
\item{n_parameters}{Number of parameters in the pool object}
\item{visits}{Character vector of unique visit names}
\item{method}{Pooling method used}
\item{n_imputations}{Number of imputations combined}
\item{conf.level}{Confidence level}
\item{tidy_df}{The full tidy tibble from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}}}
}
}
\description{
Provides a detailed visit-level breakdown of pooled analysis results with
significance flags. Shows treatment comparisons and least squares means
grouped by visit.
}
\details{
The summary output groups results by visit, showing treatment comparisons
with significance flags and least squares means. This provides a quick
overview of which visits have statistically significant treatment effects.

Significance flags:
\itemize{
\item \code{*} p < alpha (default 0.05)
\item \verb{**} p < 0.01
\item \verb{***} p < 0.001
}
}
\examples{
\donttest{
library(rbmi)
library(rbmiUtils)
data("ADMI")

ADMI$TRT <- factor(ADMI$TRT, levels = c("Placebo", "Drug A"))
ADMI$USUBJID <- factor(ADMI$USUBJID)
ADMI$AVISIT <- factor(ADMI$AVISIT)

vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
)
method <- method_bayes(n_samples = 20, control = control_bayes(warmup = 20))

ana_obj <- analyse_mi_data(ADMI, vars, method, fun = ancova)
pool_obj <- pool(ana_obj)
summary(pool_obj)
}

}
\seealso{
\itemize{
\item \code{\link[=print.pool]{print.pool()}} for compact tabular output
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} for full tidy tibble output
\item \code{\link[rbmi:pool]{rbmi::pool()}} to create pool objects
}
}
