% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_table.R
\name{model_table}
\alias{model_table}
\title{Create APA-formatted table of model results}
\usage{
model_table(
  object,
  selector,
  digits = 3,
  caption = NULL,
  show_chains = TRUE,
  show_neff = FALSE
)
}
\arguments{
\item{object}{A \code{\link{blimp_obj}} containing model results.}

\item{selector}{Optional character string specifying variable name or block to display.
If missing, creates separate tables for each variable.}

\item{digits}{Integer specifying number of decimal places. Default is 3.}

\item{caption}{Optional character string for table caption.}

\item{show_chains}{Logical indicating whether to show chain information. Default is TRUE.}

\item{show_neff}{Logical indicating whether to show effective sample size. Default is FALSE.}
}
\value{
Invisibly returns the HTML content. Primary purpose is displaying in Viewer.
}
\description{
Generates an APA-formatted HTML table of model estimates that opens in the RStudio Viewer.
Provides publication-ready tables with proper formatting for Bayesian model results.
}
\details{
The function creates APA-style tables with the following features:
\itemize{
\item Proper coefficient formatting with confidence intervals
\item Organized sections for different parameter types
\item Publication-ready styling
\item Responsive design for different screen sizes
}

Tables are displayed in the RStudio Viewer pane and can be exported or copied.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x, 1)'
    ),
    n = 100,
    seed = 10972
)

# Fit model
model <- rblimp(
    'y ~ x',
    mydata,
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Create APA table for all variables
model_table(model)

# Create table for specific variable
model_table(model, "y")

# Customize formatting
model_table(model, digits = 2, caption = "Bayesian Model Results")
\dontshow{\}) # examplesIf}
}
