% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows-radial.r
\name{radialflowmodel}
\alias{radialflowmodel}
\title{Radial Normalizing Flow (1D)}
\usage{
radialflowmodel(z_ref, alpha, beta)
}
\arguments{
\item{z_ref}{Reference point for the radial transformation.}

\item{alpha}{Positive scalar controlling the denominator.}

\item{beta}{Scalar controlling the magnitude of the deformation.}
}
\value{
A flow model object with methods:
\itemize{
\item sampleq(n)
\item logq(z0)
\item applyflow(z0)
}
}
\description{
A readable implementation of a 1-dimensional radial flow:
}
\details{
z_K = z_0 + beta / (alpha + |z_0 - z_ref|) * (z_0 - z_ref)

where:
\itemize{
\item z_ref is a reference point
\item alpha > 0 ensures numerical stability
\item beta controls the strength of the radial deformation
}

The log-determinant is computed analytically for the 1D case.
}
