% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx_build.R
\name{install_apsimng}
\alias{install_apsimng}
\title{Install ApsimNG Software}
\usage{
install_apsimng(
  repo = "https://github.com/APSIMInitiative/ApsimX.git",
  branch = "master",
  install_dir = "apsimx_build",
  overwrite = FALSE
)
}
\arguments{
\item{repo}{Character string specifying the repository of ApsimNG to install.}

\item{branch}{Character string specifying the branch of the repository to install.}

\item{install_dir}{Character string specifying the directory where ApsimNG
should be installed.}

\item{overwrite}{Logical. If TRUE, overwrites any existing installation
at the specified install directory.}
}
\value{
No return value.
}
\description{
This function installs the ApsimNG simulation software on the local system.
It handles the download and installation process for the APSIM Next Generation
agricultural modeling platform.
}
\details{
This function downloads and installs ApsimNG from the official repository.
It performs version checking, handles dependencies, and configures the
installation for use with R. The function requires administrative privileges
on Windows systems.
}
\examples{
\dontrun{
# Install latest version
install_apsimng()
install_apsimng(install_dir = "C:/MyPrograms/ApsimNG")
}

}
