% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sim_results.R
\name{plot.sim_results}
\alias{plot.sim_results}
\title{Plot \code{sim_results} Object}
\usage{
\method{plot}{sim_results}(x, template = NULL, time_points = NULL, range, type, ...)
}
\arguments{
\item{x}{\code{sim_results} object; returned by \code{\link{sim}}}

\item{template}{\code{\link[terra:SpatRaster-class]{SpatRaster}} object;
can be used as a template to create returned object}

\item{time_points}{numeric vector; specifies points in time from which
plots will be generated}

\item{range}{numeric vector of length 2; range of values to be used for the
legend (if \code{type = "continuous"}), which by default is calculated from
the N_map slot of \code{sim_result} object}

\item{type}{character vector of length 1; type of map:
"continuous" (default), "classes" or "interval"  (case-sensitive)}

\item{...}{further arguments passed to \code{\link[terra:plot]{terra::plot}}}
}
\value{
\code{\link[terra:SpatRaster-class]{SpatRaster}} object with as many layers
as the length of \code{time_points} parameter
}
\description{
Plots abundances obtained during simulation.
}
\examples{
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
sim_res <- sim(sim_data, time = 10)
plot(sim_res)
plot(sim_res, template = n1_small, time_points = c(1, 10))

# plot specific area
plot(sim_res, xlim = c(4, 10), ylim = c(0, 10))
plot(sim_res, ext = c(4, 10, 0, 10))
plot(sim_res, template = n1_small, ext = c(274000, 280000, 610000, 620000))


}
