% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{add_count.corpus}
\alias{add_count.corpus}
\alias{add_tally.corpus}
\title{Add count of observations to corpus}
\usage{
\method{add_count}{corpus}(x, ..., wt = NULL, sort = FALSE, name = NULL, .drop = NULL)

\method{add_tally}{corpus}(x, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{a \pkg{quanteda} corpus object}

\item{...}{for \code{add_count()}, document variables to group by; for
\code{add_tally()}, additional arguments passed to the method}

\item{wt}{frequency weights. Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group
\item If a variable, computes \code{sum(wt)} for each group
}}

\item{sort}{if \code{TRUE}, will sort output in descending order of \code{n}}

\item{name}{the name of the new column in the output. If omitted, it will
default to \code{n}. If there's already a column called \code{n}, it will error, and
require you to specify the name.}

\item{.drop}{not used for corpus objects; included for compatibility with
the generic}
}
\value{
a corpus with an additional document variable containing counts
}
\description{
\code{add_count()} and \code{add_tally()} are wrappers around \code{\link[dplyr:count]{dplyr::add_count()}} and
\code{\link[dplyr:count]{dplyr::add_tally()}} that add a new document variable with the number of
observations. \code{add_count()} is a shortcut for \code{group_by() + add_tally()}.
}
\examples{
# Count documents by President and add as a variable
data_corpus_inaugural \%>\%
  add_count(President) \%>\%
  summary(n = 10)

# Add total count to each document
data_corpus_inaugural \%>\%
  head() \%>\%
  add_tally() \%>\%
  summary()

# Count by multiple variables
data_corpus_inaugural \%>\%
  add_count(Party, President) \%>\%
  summary(n = 10)

# Use custom name
data_corpus_inaugural \%>\%
  add_count(Party, name = "party_count") \%>\%
  summary(n = 10)

# Add tally to show total count
data_corpus_inaugural \%>\%
  slice(1:6) \%>\%
  add_tally() \%>\%
  summary()
}
